#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <ShlOBJ.H>
#include <ShlGuid.H>
#include <ObjBase.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <String.H>

//////////////////////////////////////////////////////////////////////////////////////////

#include "Headers/NSWFL.H"

#include "Headers/Definitions.H"
#include "Headers/Service.H"

//////////////////////////////////////////////////////////////////////////////////////////

int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR CmdLine, int nCmdShow )
{
	MainInstance = hInstance;

    if(strlen(CmdLine) < 0)
    {
        return 0;
    }
    else if( strcmp(LCase(CmdLine), "/openconsole") == 0)
    {
   		if( xIsServiceInstalled(ThisServiceName) == _No_ )
   		{
       		MessageBox(NULL, "The service is not installed.", TitleCaption, MB_ICONINFORMATION );
   			return 0;
        }

        if(IsServiceActive(ThisServiceEvent) == _No_)
        {
            if(MessageBox(NULL, "The service is not started. Would you like to start it now?", TitleCaption, MB_YESNO|MB_APPLMODAL) == IDNO)
            {
                return 0;
            }

    		if(xStartService(ThisServiceName) == _Success_)
            {
    //    		MessageBox(NULL, "The service was started sucessfully.", TitleCaption, MB_ICONINFORMATION );
            }
            else{
        		MessageBox(NULL, "Failed to start the service.", TitleCaption, MB_ICONINFORMATION );
       			return 0;
            }
        }

        if(xTriggerEvent(OpenServerConsoleEventName) != _Success_)
        {
            MessageBox(NULL, "Failed to modify service event state.", TitleCaption, MB_ICONINFORMATION );
        }

        return 0;
    }
    else if( strcmp(LCase(CmdLine), "/openmaindialog") == 0)
    {
   		if( xIsServiceInstalled(ThisServiceName) == _No_ )
   		{
       		MessageBox(NULL, "The service is not installed.", TitleCaption, MB_ICONINFORMATION );
   			return 0;
        }

        if(IsServiceActive(ThisServiceEvent) == _No_)
        {
            if(MessageBox(NULL, "The service is not started. Would you like to start it now?", TitleCaption, MB_YESNO|MB_APPLMODAL) == IDNO)
            {
                return 0;
            }

    		if(xStartService(ThisServiceName) == _Success_)
            {
    //    		MessageBox(NULL, "The service was started sucessfully.", TitleCaption, MB_ICONINFORMATION );
            }
            else{
        		MessageBox(NULL, "Failed to start the service.", TitleCaption, MB_ICONINFORMATION );
       			return 0;
            }
        }

        if(xTriggerEvent(OpenServerMainDialogEventName) != _Success_)
        {
            MessageBox(NULL, "Failed to modify service event state.", TitleCaption, MB_ICONINFORMATION );
        }

        return 0;
    }
    else if( strcmp(LCase(CmdLine), "/install") == 0)
    {
    	char Path[257];
        char Application[257];
    	unsigned long SizeOfPath = sizeof(Path);

    	short ServiceInstalled = xIsServiceInstalled(ThisServiceName);

		if( ServiceInstalled == _Yes_ )
		{
    		//MessageBox(NULL, "The service is already installed.", TitleCaption, MB_ICONINFORMATION );
			return 0;
		}

    	if(!Get_StringRegistryValue(HKEY_LOCAL_MACHINE, RegistryKey, "Path", Path, SizeOfPath))
    	{
    		MessageBox(NULL, "Failed to obtain required registry values.", TitleCaption, MB_ICONINFORMATION );
    		return FALSE;
    	}

    	sprintf(Application, "%s\\%s", Path, "SQLEServer.Exe");

		if ( xInstallService(ThisServiceName, ThisDisplayName, Application) == _Success_ )
		{
//			MessageBox(NULL, "The service was installed sucessfully.", TitleCaption, MB_ICONINFORMATION );
			return 0;
		}
		else{
			MessageBox(NULL, "Failed to install the service.", TitleCaption, MB_ICONINFORMATION );
			return 0;
		}

        return 0;
    }
    else if( strcmp(LCase(CmdLine), "/start") == 0)
    {
		if( xIsServiceInstalled(ThisServiceName) == _No_ )
		{
    		MessageBox(NULL, "The service is not installed.", TitleCaption, MB_ICONINFORMATION );
			return 0;
		}

        if(IsServiceActive(ThisServiceEvent) == _Yes_)
        {
//    		MessageBox(NULL, "The service is already active.", TitleCaption, MB_ICONINFORMATION );
			return 0;
        }

		if(xStartService(ThisServiceName) == _Success_)
        {
//    		MessageBox(NULL, "The service was started sucessfully.", TitleCaption, MB_ICONINFORMATION );
            return 0;
        }
        else{
    		MessageBox(NULL, "Failed to start the service.", TitleCaption, MB_ICONINFORMATION );
   			return 0;
        }

        return 0;
    }
    else if( strcmp(LCase(CmdLine), "/delete") == 0)
    {
		if( xIsServiceInstalled(ThisServiceName) == _No_ )
		{
//    		MessageBox(NULL, "The service is not installed.", TitleCaption, MB_ICONINFORMATION );
			return 0;
		}

        if(IsServiceActive(ThisServiceEvent) == _Yes_)
        {
            xCommandService(ThisServiceName, SERVICE_CONTROL_STOP); // Failure would not be an error.
			return 0;
        }

    	if( xUninstallService(ThisServiceName) == _Success_ )
    	{
//    		MessageBox(NULL, "The service was marked for deletion.", TitleCaption, MB_ICONINFORMATION );
    		return 0;
       	}
        else{
    		MessageBox(NULL, "Failed to mark the service for deletion.", TitleCaption, MB_ICONINFORMATION );
            return 0;
        }

        return 0;
    }
    else if( strcmp(LCase(CmdLine), "/stop") == 0)
    {
		if( xIsServiceInstalled(ThisServiceName) == _No_ )
		{
//    		MessageBox(NULL, "The service is not installed.", TitleCaption, MB_ICONINFORMATION );
			return 0;
		}

        if(IsServiceActive(ThisServiceEvent) == _No_)
        {
//    		MessageBox(NULL, "The service is already stopped.", TitleCaption, MB_ICONINFORMATION );
			return 0;
        }

    	if( xCommandService(ThisServiceName, SERVICE_CONTROL_STOP) == _Success_ )
    	{
//    		MessageBox(NULL, "The service was stopped.", TitleCaption, MB_ICONINFORMATION );
    		return 0;
       	}
        else{
    		MessageBox(NULL, "Failed to stop the service.", TitleCaption, MB_ICONINFORMATION );
            return 0;
        }

        return 0;
    }

	return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////

